package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 借阅性质
 * </p>
 *
 * @author ultraman
 * @since 2021-03-16
 */
public enum ApplyRenewalStatus {

    __1("-1", "取消借阅"),
    _0("0", "正常借阅"),
    _1("1", "续借");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApplyRenewalStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyRenewalStatus fromCode(String code){
        switch(code) {
            case "-1":
                return __1;
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
