package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 会记凭证类别
 * </p>
 *
 * @author ultraman
 * @since 2021-04-28
 */
public enum AccountVoucherType {

    A001001("A001001", "付款凭证"),
    A001002("A001002", "收款凭证"),
    A001003("A001003", "记账凭证"),
    A001004("A001004", "转账凭证"),
    A001005("A001005", "通用记账凭证");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AccountVoucherType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountVoucherType fromCode(String code){
        switch(code) {
            case "A001001":
                return A001001;
            case "A001002":
                return A001002;
            case "A001003":
                return A001003;
            case "A001004":
                return A001004;
            case "A001005":
                return A001005;
            default:
                return null;
        }
    }
}
