package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 库位类型
 * </p>
 *
 * @author ultraman
 * @since 2021-06-03
 */
public enum LocationType {

    WAREHOUSE("warehouse", "档案室"),
    OUTSOURCER("outsourcer", "外包商");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    LocationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LocationType fromCode(String code){
        switch(code) {
            case "warehouse":
                return WAREHOUSE;
            case "outsourcer":
                return OUTSOURCER;
            default:
                return null;
        }
    }
}
