package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-06-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BorrowResource implements Serializable {

  private static final long serialVersionUID=1L;

  private Long borrowId;

  private Long orgId;

  private String resourceType;

  private Long resourceId;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime borrowTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime returnTime;

  private Boolean loseFlag;

  private Long overdueDay;

  private String expressCompany;

  private String expressNo;

  private String authTypes;

  private String remark;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String materialSituation;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("borrow_id", borrowId);
      map.put("org_id", orgId);
      map.put("resource_type", resourceType);
      map.put("resource_id", resourceId);
      map.put("auth_time", BocpGenUtils.toTimestamp(authTime));
      map.put("borrow_time", BocpGenUtils.toTimestamp(borrowTime));
      map.put("return_time", BocpGenUtils.toTimestamp(returnTime));
      map.put("lose_flag", loseFlag);
      map.put("overdue_day", overdueDay);
      map.put("express_company", expressCompany);
      map.put("express_no", expressNo);
      map.put("auth_types", authTypes);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("material_situation", materialSituation);
      return map;
  }

  public static BorrowResource fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    BorrowResource entity = new BorrowResource();
    if(map.containsKey("borrow_id")) {
      Object obj = map.get("borrow_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBorrowId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBorrowId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBorrowId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("resource_type")) {
      Object obj = map.get("resource_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResourceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("resource_id")) {
      Object obj = map.get("resource_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setResourceId((Long)obj);
        } else if(obj instanceof String) {
          entity.setResourceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setResourceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("auth_time")) {
      Object obj = map.get("auth_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthTime(null);
      }
    }
    if(map.containsKey("borrow_time")) {
      Object obj = map.get("borrow_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBorrowTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBorrowTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBorrowTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBorrowTime(null);
      }
    }
    if(map.containsKey("return_time")) {
      Object obj = map.get("return_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReturnTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReturnTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReturnTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReturnTime(null);
      }
    }
    if(map.containsKey("lose_flag")) {
      Object obj = map.get("lose_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLoseFlag((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setLoseFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("overdue_day")) {
      Object obj = map.get("overdue_day");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOverdueDay((Long)obj);
        } else if(obj instanceof String) {
          entity.setOverdueDay(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOverdueDay(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("express_company")) {
      Object obj = map.get("express_company");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpressCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("express_no")) {
      Object obj = map.get("express_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpressNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_types")) {
      Object obj = map.get("auth_types");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthTypes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material_situation")) {
      Object obj = map.get("material_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialSituation((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
