package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 资料对象类型
 * </p>
 *
 * @author ultraman
 * @since 2021-06-26
 */
public enum AccountDataObjectType {

    INVOICE("invoice", "发票"),
    BILL("bill", "单据"),
    ATTACHEMENT("attachement", "附件"),
    VOUCHER("voucher", "凭证");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AccountDataObjectType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountDataObjectType fromCode(String code){
        switch(code) {
            case "invoice":
                return INVOICE;
            case "bill":
                return BILL;
            case "attachement":
                return ATTACHEMENT;
            case "voucher":
                return VOUCHER;
            default:
                return null;
        }
    }
}
