package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 处理状态
 * </p>
 *
 * @author ultraman
 * @since 2021-06-26
 */
public enum HandleStatus {

    PENDING("pending", "待处理"),
    HANDLED("handled", "已处理");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    HandleStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HandleStatus fromCode(String code){
        switch(code) {
            case "pending":
                return PENDING;
            case "handled":
                return HANDLED;
            default:
                return null;
        }
    }
}
