package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-06-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ConfigArchivesType implements Serializable {

  private static final long serialVersionUID=1L;

  private String businessType;

  private String typeNo;

  private String typeName;

  private String typeDesc;

  private Long term;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String custodyFormType;

  private Long tenant;

  private Long orgId;

  private String expSubmitFlag;

  private String biSwitch;

  private String submitType;

  private String composeRelaction;

  private String archiveNoRule;

  private String volumeContinuative;

  private String locationNoContinuative;

  private String locationOrderContinuative;

  private String orgName;

  private String accountDataObjectType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("business_type", businessType);
      map.put("type_no", typeNo);
      map.put("type_name", typeName);
      map.put("type_desc", typeDesc);
      map.put("term", term);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("custody_form_type", custodyFormType);
      map.put("tenant", tenant);
      map.put("org_id", orgId);
      map.put("exp_submit_flag", expSubmitFlag);
      map.put("bi_switch", biSwitch);
      map.put("submit_type", submitType);
      map.put("compose_relaction", composeRelaction);
      map.put("archive_no_rule", archiveNoRule);
      map.put("volume_continuative", volumeContinuative);
      map.put("location_no_continuative", locationNoContinuative);
      map.put("location_order_continuative", locationOrderContinuative);
      map.put("org_name", orgName);
      map.put("account_data_object_type", accountDataObjectType);
      return map;
  }

  public static ConfigArchivesType fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    ConfigArchivesType entity = new ConfigArchivesType();
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type_no")) {
      Object obj = map.get("type_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type_name")) {
      Object obj = map.get("type_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type_desc")) {
      Object obj = map.get("type_desc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("term")) {
      Object obj = map.get("term");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTerm((Long)obj);
        } else if(obj instanceof String) {
          entity.setTerm(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTerm(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custody_form_type")) {
      Object obj = map.get("custody_form_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustodyFormType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant")) {
      Object obj = map.get("tenant");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenant((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenant(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenant(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("exp_submit_flag")) {
      Object obj = map.get("exp_submit_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpSubmitFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi_switch")) {
      Object obj = map.get("bi_switch");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBiSwitch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submit_type")) {
      Object obj = map.get("submit_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compose_relaction")) {
      Object obj = map.get("compose_relaction");
      if(obj != null) {
        if(obj instanceof String){
          entity.setComposeRelaction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("archive_no_rule")) {
      Object obj = map.get("archive_no_rule");
      if(obj != null) {
        if(obj instanceof String){
          entity.setArchiveNoRule((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume_continuative")) {
      Object obj = map.get("volume_continuative");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVolumeContinuative((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("location_no_continuative")) {
      Object obj = map.get("location_no_continuative");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLocationNoContinuative((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("location_order_continuative")) {
      Object obj = map.get("location_order_continuative");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLocationOrderContinuative((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_data_object_type")) {
      Object obj = map.get("account_data_object_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataObjectType((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
