package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-06-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class VolumeAppraisalRelation implements Serializable {

  private static final long serialVersionUID=1L;

  private Long applyId;

  private Long volumeId;

  private String status;

  private String type;

  private Long renewYear;

  private String comment;

  private Long originWarehouseId;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private Long appraisalUserId;

  private String appraisalUserName;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime appraisalTime;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("apply_id", applyId);
      map.put("volume_id", volumeId);
      map.put("status", status);
      map.put("type", type);
      map.put("renew_year", renewYear);
      map.put("comment", comment);
      map.put("origin_warehouse_id", originWarehouseId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("appraisal_user_id", appraisalUserId);
      map.put("appraisal_user_name", appraisalUserName);
      map.put("appraisal_time", BocpGenUtils.toTimestamp(appraisalTime));
      return map;
  }

  public static VolumeAppraisalRelation fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    VolumeAppraisalRelation entity = new VolumeAppraisalRelation();
    if(map.containsKey("apply_id")) {
      Object obj = map.get("apply_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setApplyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setApplyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("volume_id")) {
      Object obj = map.get("volume_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVolumeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setVolumeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVolumeId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("renew_year")) {
      Object obj = map.get("renew_year");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRenewYear((Long)obj);
        } else if(obj instanceof String) {
          entity.setRenewYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRenewYear(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("comment")) {
      Object obj = map.get("comment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setComment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_warehouse_id")) {
      Object obj = map.get("origin_warehouse_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOriginWarehouseId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOriginWarehouseId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOriginWarehouseId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appraisal_user_id")) {
      Object obj = map.get("appraisal_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAppraisalUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAppraisalUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAppraisalUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("appraisal_user_name")) {
      Object obj = map.get("appraisal_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAppraisalUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appraisal_time")) {
      Object obj = map.get("appraisal_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAppraisalTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAppraisalTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAppraisalTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAppraisalTime(null);
      }
    }
    return entity;
  }
}
