package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 电子签章状态
 * </p>
 *
 * @author ultraman
 * @since 2021-07-03
 */
public enum ElectronSignStatus {

    UNENCRYPTED("unencrypted", "未加密"),
    ENCRYPTED("encrypted", "已加密");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ElectronSignStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ElectronSignStatus fromCode(String code){
        switch(code) {
            case "unencrypted":
                return UNENCRYPTED;
            case "encrypted":
                return ENCRYPTED;
            default:
                return null;
        }
    }
}
