package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票档案票种
 * </p>
 *
 * @author ultraman
 * @since 2021-07-03
 */
public enum InvoiceArchiveType {

    _5("5", "增值税发票"),
    _6("6", "火车票"),
    _7("7", "飞机票"),
    _8("8", "定额发票"),
    _9("9", "出租车发票"),
    _10("10", "过路费发票"),
    _11("11", "通用机打发票"),
    _12("12", "公共汽车发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceArchiveType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceArchiveType fromCode(String code){
        switch(code) {
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            default:
                return null;
        }
    }
}
