package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.elephantarchives.entity.OriginalTicket;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-07-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketMachine extends OriginalTicket {


  private String invoiceStatus;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrewDate;

  private String taxRate;

  private String purchaserName;

  private String purchaserTaxNo;

  private String sellerName;

  private String sellerTaxNo;

  private String machineCode;

  private String checkCode;

  private String cipherText;

  private String cashierName;

  private String checkerName;

  private String invoicerName;

  private String purchaserAddress;

  private String purchaserTel;

  private String purchaserAddrTel;

  private String purchaserBankName;

  private String purchaserBankAccount;

  private String purchaserBankNameAccount;

  private String sellerAddress;

  private String sellerTel;

  private String sellerAddrTel;

  private String sellerBankName;

  private String sellerBankAccount;

  private String sellerBankNameAccount;

  private String remark;

  private String invoiceCodeP;

  private String invoiceNoP;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("invoice_status", invoiceStatus);
      map.put("paper_drew_date", BocpGenUtils.toTimestamp(paperDrewDate));
      map.put("tax_rate", taxRate);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("machine_code", machineCode);
      map.put("check_code", checkCode);
      map.put("cipher_text", cipherText);
      map.put("cashier_name", cashierName);
      map.put("checker_name", checkerName);
      map.put("invoicer_name", invoicerName);
      map.put("purchaser_address", purchaserAddress);
      map.put("purchaser_tel", purchaserTel);
      map.put("purchaser_addr_tel", purchaserAddrTel);
      map.put("purchaser_bank_name", purchaserBankName);
      map.put("purchaser_bank_account", purchaserBankAccount);
      map.put("purchaser_bank_name_account", purchaserBankNameAccount);
      map.put("seller_address", sellerAddress);
      map.put("seller_tel", sellerTel);
      map.put("seller_addr_tel", sellerAddrTel);
      map.put("seller_bank_name", sellerBankName);
      map.put("seller_bank_account", sellerBankAccount);
      map.put("seller_bank_name_account", sellerBankNameAccount);
      map.put("remark", remark);
      map.put("invoice_code_p", invoiceCodeP);
      map.put("invoice_no_p", invoiceNoP);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static TicketMachine fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    TicketMachine entity = new TicketMachine();
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("company_code")) {
      Object obj = map.get("company_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orig_system")) {
      Object obj = map.get("orig_system");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigSystem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sensitive_flag")) {
      Object obj = map.get("sensitive_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lose_flag")) {
      Object obj = map.get("lose_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLoseFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_flag")) {
      Object obj = map.get("exception_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warning_flag")) {
      Object obj = map.get("warning_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("material_status")) {
      Object obj = map.get("material_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("borrow_status")) {
      Object obj = map.get("borrow_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sensitive_situation")) {
      Object obj = map.get("sensitive_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveSituation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("material_situation")) {
      Object obj = map.get("material_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialSituation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("borrow_situation")) {
      Object obj = map.get("borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowSituation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sorting_status")) {
      Object obj = map.get("sorting_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSortingStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_data_type_id")) {
      Object obj = map.get("account_data_type_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountDataTypeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountDataTypeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAccountDataTypeId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("account_data_type_name")) {
      Object obj = map.get("account_data_type_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_data_type_no")) {
      Object obj = map.get("account_data_type_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataTypeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("custody_form_type")) {
      Object obj = map.get("custody_form_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustodyFormType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_type")) {
      Object obj = map.get("exception_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipher_text")) {
      Object obj = map.get("cipher_text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name_account")) {
      Object obj = map.get("purchaser_bank_name_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name_account")) {
      Object obj = map.get("seller_bank_name_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code_p")) {
      Object obj = map.get("invoice_code_p");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCodeP((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no_p")) {
      Object obj = map.get("invoice_no_p");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoP((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
