package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单证状态
 * </p>
 *
 * @author ultraman
 * @since 2021-07-06
 */
public enum TicketStatus {

    __1("-1", "作废"),
    _0("0", "正常"),
    _1("1", "红冲"),
    _2("2", "被红冲");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TicketStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TicketStatus fromCode(String code){
        switch(code) {
            case "-1":
                return __1;
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
