package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.elephantarchives.entity.BaseVoucher;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-07-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OtherVoucher extends BaseVoucher {


  private String voucherName;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("voucher_name", voucherName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static OtherVoucher fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    OtherVoucher entity = new OtherVoucher();
    if(map.containsKey("voucher_no")) {
      Object obj = map.get("voucher_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("company_code")) {
      Object obj = map.get("company_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("image_count")) {
      Object obj = map.get("image_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setImageCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setImageCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("volume_id")) {
      Object obj = map.get("volume_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVolumeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setVolumeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVolumeId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orig_system")) {
      Object obj = map.get("orig_system");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigSystem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sensitive_flag")) {
      Object obj = map.get("sensitive_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("virtual_flag")) {
      Object obj = map.get("virtual_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVirtualFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("index_status")) {
      Object obj = map.get("index_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIndexStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_flag")) {
      Object obj = map.get("exception_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warning_flag")) {
      Object obj = map.get("warning_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("borrow_status")) {
      Object obj = map.get("borrow_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("material_status")) {
      Object obj = map.get("material_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("material_situation")) {
      Object obj = map.get("material_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialSituation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sensitive_situation")) {
      Object obj = map.get("sensitive_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveSituation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("borrow_situation")) {
      Object obj = map.get("borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowSituation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accounting_period")) {
      Object obj = map.get("accounting_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAccountingPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setAccountingPeriod(null);
      }
    }
    if(map.containsKey("account_data_type_id")) {
      Object obj = map.get("account_data_type_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountDataTypeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountDataTypeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAccountDataTypeId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("account_data_type_name")) {
      Object obj = map.get("account_data_type_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_data_type_no")) {
      Object obj = map.get("account_data_type_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataTypeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("archive_type_id")) {
      Object obj = map.get("archive_type_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setArchiveTypeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setArchiveTypeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setArchiveTypeId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("archive_no")) {
      Object obj = map.get("archive_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setArchiveNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("archive_type_name")) {
      Object obj = map.get("archive_type_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setArchiveTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sorting_user_id")) {
      Object obj = map.get("sorting_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSortingUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSortingUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSortingUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sorting_user_name")) {
      Object obj = map.get("sorting_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSortingUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sorting_time")) {
      Object obj = map.get("sorting_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSortingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSortingTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSortingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setSortingTime(null);
      }
    }
    if(map.containsKey("tags")) {
      Object obj = map.get("tags");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTags((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("filing_apply_user_id")) {
      Object obj = map.get("filing_apply_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFilingApplyUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setFilingApplyUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFilingApplyUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("filing_apply_user_name")) {
      Object obj = map.get("filing_apply_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFilingApplyUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sign_no")) {
      Object obj = map.get("sign_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sign_time")) {
      Object obj = map.get("sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSignTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setSignTime(null);
      }
    }
    if(map.containsKey("signer")) {
      Object obj = map.get("signer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSigner((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sign_status")) {
      Object obj = map.get("sign_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("filing_time")) {
      Object obj = map.get("filing_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFilingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setFilingTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setFilingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setFilingTime(null);
      }
    }
    if(map.containsKey("archive_type_no")) {
      Object obj = map.get("archive_type_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setArchiveTypeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("custody_form_type")) {
      Object obj = map.get("custody_form_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustodyFormType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_type")) {
      Object obj = map.get("exception_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("increase_no")) {
      Object obj = map.get("increase_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIncreaseNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("voucher_name")) {
      Object obj = map.get("voucher_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
