package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 审核状态
 * </p>
 *
 * @author ultraman
 * @since 2021-07-08
 */
public enum ExamineStatus {

    UN_CHECK("un_check", "待审核"),
    CHECKING("checking", "审核中"),
    CHECKED("checked", "审核通过");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExamineStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExamineStatus fromCode(String code){
        switch(code) {
            case "un_check":
                return UN_CHECK;
            case "checking":
                return CHECKING;
            case "checked":
                return CHECKED;
            default:
                return null;
        }
    }
}
