package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 借阅情况
 * </p>
 *
 * @author ultraman
 * @since 2021-07-12
 */
public enum BorrowSituation {

    ALL("ALL", "全部借出"),
    PART("PART", "部分借出"),
    NOT("NOT", "未借出");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BorrowSituation(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BorrowSituation fromCode(String code){
        switch(code) {
            case "ALL":
                return ALL;
            case "PART":
                return PART;
            case "NOT":
                return NOT;
            default:
                return null;
        }
    }
}
