package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 会计资料类型
 * </p>
 *
 * @author ultraman
 * @since 2021-07-20
 */
public enum AccountDataType {

    _1("1", "会计凭证"),
    _2("2", "会计帐薄"),
    _3("3", "财务报告"),
    _4("4", "其他会计资料");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AccountDataType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountDataType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
