package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 盘点异常类型
 * </p>
 *
 * @author ultraman
 * @since 2021-07-20
 */
public enum InventoryExceptionType {

    _1("1", "系统缺失"),
    _2("2", "库位不一致"),
    _3("3", "实物缺失");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InventoryExceptionType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InventoryExceptionType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
