package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 凭证提交状态
 * </p>
 *
 * @author ultraman
 * @since 2021-07-20
 */
public enum VoucherSubmitStatus {

    _0("0", "未提交"),
    _1("1", "已提交"),
    _2("2", "待办"),
    _3("3", "已立册");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VoucherSubmitStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VoucherSubmitStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
