package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 生效范围
 * </p>
 *
 * @author ultraman
 * @since 2021-08-05
 */
public enum EffctiveRange {

    _0("0", "集团范围"),
    _1("1", "公司范围");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EffctiveRange(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EffctiveRange fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
