package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 上传文件类型
 * </p>
 *
 * @author ultraman
 * @since 2021-08-23
 */
public enum UploadFileType {

    JPG("jpg", "jpg"),
    JPEG("jpeg", "jpeg"),
    OFD("ofd", "ofd"),
    PNG("png", "png"),
    BMP("bmp", "bmp"),
    PDF("pdf", "pdf"),
    XLS("xls", "xls"),
    DOC("doc", "doc"),
    DOCX("docx", "docx"),
    XLSX("xlsx", "xlsx");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    UploadFileType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static UploadFileType fromCode(String code){
        switch(code) {
            case "jpg":
                return JPG;
            case "jpeg":
                return JPEG;
            case "ofd":
                return OFD;
            case "png":
                return PNG;
            case "bmp":
                return BMP;
            case "pdf":
                return PDF;
            case "xls":
                return XLS;
            case "doc":
                return DOC;
            case "docx":
                return DOCX;
            case "xlsx":
                return XLSX;
            default:
                return null;
        }
    }
}
