package com.xforceplus.elephantarchives.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-08-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class VoucherItem implements Serializable {

  private static final long serialVersionUID=1L;

  private String remark;

  private String directoryNo;

  private BigDecimal debitAmount;

  private BigDecimal creditAmount;

  private String customerNo;

  private Long voucherId;

  private String subjectName;

  private String subjectNo;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("remark", remark);
      map.put("directory_no", directoryNo);
      map.put("debit_amount", debitAmount);
      map.put("credit_amount", creditAmount);
      map.put("customer_no", customerNo);
      map.put("voucher_id", voucherId);
      map.put("subject_name", subjectName);
      map.put("subject_no", subjectNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static VoucherItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    VoucherItem entity = new VoucherItem();
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("directory_no")) {
      Object obj = map.get("directory_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDirectoryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("debit_amount")) {
      Object obj = map.get("debit_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDebitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDebitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDebitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDebitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDebitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("credit_amount")) {
      Object obj = map.get("credit_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCreditAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCreditAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCreditAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCreditAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreditAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customer_no")) {
      Object obj = map.get("customer_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucher_id")) {
      Object obj = map.get("voucher_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVoucherId((Long)obj);
        } else if(obj instanceof String) {
          entity.setVoucherId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVoucherId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("subject_name")) {
      Object obj = map.get("subject_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subject_no")) {
      Object obj = map.get("subject_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubjectNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
