package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 档案标签
 * </p>
 *
 * @author ultraman
 * @since 2021-08-30
 */
public enum ArchiveTags {

    BACK("back", "退"),
    RUIN("ruin", "毁"),
    REJECT("reject", "拒");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ArchiveTags(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ArchiveTags fromCode(String code){
        switch(code) {
            case "back":
                return BACK;
            case "ruin":
                return RUIN;
            case "reject":
                return REJECT;
            default:
                return null;
        }
    }
}
