package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 样式小类
 * </p>
 *
 * @author ultraman
 * @since 2021-08-30
 */
public enum StyleSmallType {

    COVER_B001("coverB001", "凭证封面"),
    COVER_B002("coverB002", "会计账簿"),
    COVER_B003("coverB003", "会计报告"),
    A001003("A001003", "记账凭证"),
    A001001("A001001", "付款凭证"),
    A001002("A001002", "收款凭证"),
    A001004("A001004", "转账凭证"),
    A001005("A001005", "通用记账凭证"),
    PROCESS001("process001", "非凭证类追溯表");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StyleSmallType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StyleSmallType fromCode(String code){
        switch(code) {
            case "coverB001":
                return COVER_B001;
            case "coverB002":
                return COVER_B002;
            case "coverB003":
                return COVER_B003;
            case "A001003":
                return A001003;
            case "A001001":
                return A001001;
            case "A001002":
                return A001002;
            case "A001004":
                return A001004;
            case "A001005":
                return A001005;
            case "process001":
                return PROCESS001;
            default:
                return null;
        }
    }
}
