package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 资料规则Class
 * </p>
 *
 * @author ultraman
 * @since 2021-09-14
 */
public enum AccountRuleClass {

    CLASS("class", "class");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AccountRuleClass(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountRuleClass fromCode(String code){
        switch(code) {
            case "class":
                return CLASS;
            default:
                return null;
        }
    }
}
