package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-09-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ArchiveIndex implements Serializable {

  private static final long serialVersionUID=1L;

  private Long orgId;

  private String businessType;

  private Long entityId;

  private String entityType;

  private Long parentEntityId;

  private String parentEntityType;

  private Long voucherId;

  private Long leftValue;

  private Long rightValue;

  private String materialStatus;

  private String imageOrder;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String exceptionFlag;

  private String invoiceType;

  private String custodyFormType;

  private String directionType;

  private Long level;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("org_id", orgId);
      map.put("business_type", businessType);
      map.put("entity_id", entityId);
      map.put("entity_type", entityType);
      map.put("parent_entity_id", parentEntityId);
      map.put("parent_entity_type", parentEntityType);
      map.put("voucher_id", voucherId);
      map.put("left_value", leftValue);
      map.put("right_value", rightValue);
      map.put("material_status", materialStatus);
      map.put("image_order", imageOrder);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("exception_flag", exceptionFlag);
      map.put("invoice_type", invoiceType);
      map.put("custody_form_type", custodyFormType);
      map.put("direction_type", directionType);
      map.put("level", level);
      return map;
  }

  public static ArchiveIndex fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ArchiveIndex entity = new ArchiveIndex();
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entity_id")) {
      Object obj = map.get("entity_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEntityId((Long)obj);
        } else if(obj instanceof String) {
          entity.setEntityId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setEntityId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("entity_type")) {
      Object obj = map.get("entity_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntityType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parent_entity_id")) {
      Object obj = map.get("parent_entity_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setParentEntityId((Long)obj);
        } else if(obj instanceof String) {
          entity.setParentEntityId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setParentEntityId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("parent_entity_type")) {
      Object obj = map.get("parent_entity_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setParentEntityType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucher_id")) {
      Object obj = map.get("voucher_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVoucherId((Long)obj);
        } else if(obj instanceof String) {
          entity.setVoucherId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVoucherId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("left_value")) {
      Object obj = map.get("left_value");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLeftValue((Long)obj);
        } else if(obj instanceof String) {
          entity.setLeftValue(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setLeftValue(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("right_value")) {
      Object obj = map.get("right_value");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRightValue((Long)obj);
        } else if(obj instanceof String) {
          entity.setRightValue(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRightValue(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("material_status")) {
      Object obj = map.get("material_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("image_order")) {
      Object obj = map.get("image_order");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImageOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_flag")) {
      Object obj = map.get("exception_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custody_form_type")) {
      Object obj = map.get("custody_form_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustodyFormType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("direction_type")) {
      Object obj = map.get("direction_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDirectionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("level")) {
      Object obj = map.get("level");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLevel((Long)obj);
        } else if(obj instanceof String) {
          entity.setLevel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setLevel(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }
}
