package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-09-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Volume implements Serializable {

  private static final long serialVersionUID=1L;

  private Long orgId;

  private Long companyId;

  private String companyCode;

  private String businessType;

  private String volumeNo;

  private Long volumeCount;

  private Long volumeOrder;

  private String status;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingPeriod;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endDate;

  private String voucherMinNo;

  private String voucherMaxNo;

  private String volumeUsername;

  private Long boxId;

  private Long locationId;

  private Long warehouseId;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String companyName;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime volumeTime;

  private String materialSituation;

  private String exceptionFlag;

  private String sensitiveSituation;

  private String borrowSituation;

  private Long directoryId;

  private String name;

  private String approvalStatus;

  private String approvalFlowNo;

  private String currency;

  private Long collectUserId;

  private String collectUserName;

  private Long filingApplyUserId;

  private String filingApplyUserName;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime filingApplyTime;

  private String signNo;

  private String signer;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime collectTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime filingTime;

  private Long accountingYear;

  private Long fileCount;

  private String approvalBusinessKey;

  private String approvalPendingUserId;

  private String approvalProcessInfo;

  private String approvalRejectFlag;

  private String approvalRejectRemark;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime approvalRejectTime;

  private String filingNo;

  private String tags;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime destroyTime;

  private String outboundType;

  private String custodyType;

  private Long custodyYear;

  private Long outsourcerId;

  private String outsourcerLocation;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime custodyExpire;

  private String configArchiveTypeNo;

  private String approvalRejecter;

  private String exceptionInfo;

  private String orgCode;

  private String increaseNo;

  private Boolean deleted;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime storageTime;

  private String storageOperator;

  private String outboundFlag;

  private String outboundReason;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime outboundTime;

  private String outboundOperater;

  private String paperBorrowSituation;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("org_id", orgId);
      map.put("company_id", companyId);
      map.put("company_code", companyCode);
      map.put("business_type", businessType);
      map.put("volume_no", volumeNo);
      map.put("volume_count", volumeCount);
      map.put("volume_order", volumeOrder);
      map.put("status", status);
      map.put("accounting_period", BocpGenUtils.toTimestamp(accountingPeriod));
      map.put("start_date", BocpGenUtils.toTimestamp(startDate));
      map.put("end_date", BocpGenUtils.toTimestamp(endDate));
      map.put("voucher_min_no", voucherMinNo);
      map.put("voucher_max_no", voucherMaxNo);
      map.put("volume_username", volumeUsername);
      map.put("box_id", boxId);
      map.put("location_id", locationId);
      map.put("warehouse_id", warehouseId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("company_name", companyName);
      map.put("volume_time", BocpGenUtils.toTimestamp(volumeTime));
      map.put("material_situation", materialSituation);
      map.put("exception_flag", exceptionFlag);
      map.put("sensitive_situation", sensitiveSituation);
      map.put("borrow_situation", borrowSituation);
      map.put("directory_id", directoryId);
      map.put("name", name);
      map.put("approval_status", approvalStatus);
      map.put("approval_flow_no", approvalFlowNo);
      map.put("currency", currency);
      map.put("collect_user_id", collectUserId);
      map.put("collect_user_name", collectUserName);
      map.put("filing_apply_user_id", filingApplyUserId);
      map.put("filing_apply_user_name", filingApplyUserName);
      map.put("filing_apply_time", BocpGenUtils.toTimestamp(filingApplyTime));
      map.put("sign_no", signNo);
      map.put("signer", signer);
      map.put("sign_time", BocpGenUtils.toTimestamp(signTime));
      map.put("collect_time", BocpGenUtils.toTimestamp(collectTime));
      map.put("filing_time", BocpGenUtils.toTimestamp(filingTime));
      map.put("accounting_year", accountingYear);
      map.put("file_count", fileCount);
      map.put("approval_business_key", approvalBusinessKey);
      map.put("approval_pending_user_id", approvalPendingUserId);
      map.put("approval_process_info", approvalProcessInfo);
      map.put("approval_reject_flag", approvalRejectFlag);
      map.put("approval_reject_remark", approvalRejectRemark);
      map.put("approval_reject_time", BocpGenUtils.toTimestamp(approvalRejectTime));
      map.put("filing_no", filingNo);
      map.put("tags", tags);
      map.put("destroy_time", BocpGenUtils.toTimestamp(destroyTime));
      map.put("outbound_type", outboundType);
      map.put("custody_type", custodyType);
      map.put("custody_year", custodyYear);
      map.put("outsourcer_id", outsourcerId);
      map.put("outsourcer_location", outsourcerLocation);
      map.put("custody_expire", BocpGenUtils.toTimestamp(custodyExpire));
      map.put("config_archive_type_no", configArchiveTypeNo);
      map.put("approval_rejecter", approvalRejecter);
      map.put("exception_info", exceptionInfo);
      map.put("org_code", orgCode);
      map.put("increase_no", increaseNo);
      map.put("deleted", deleted);
      map.put("storage_time", BocpGenUtils.toTimestamp(storageTime));
      map.put("storage_operator", storageOperator);
      map.put("outbound_flag", outboundFlag);
      map.put("outbound_reason", outboundReason);
      map.put("outbound_time", BocpGenUtils.toTimestamp(outboundTime));
      map.put("outbound_operater", outboundOperater);
      map.put("paper_borrow_situation", paperBorrowSituation);
      return map;
  }

  public static Volume fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Volume entity = new Volume();
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("company_code")) {
      Object obj = map.get("company_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume_no")) {
      Object obj = map.get("volume_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVolumeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume_count")) {
      Object obj = map.get("volume_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVolumeCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setVolumeCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVolumeCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("volume_order")) {
      Object obj = map.get("volume_order");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVolumeOrder((Long)obj);
        } else if(obj instanceof String) {
          entity.setVolumeOrder(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVolumeOrder(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accounting_period")) {
      Object obj = map.get("accounting_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingPeriod(null);
      }
    }
    if(map.containsKey("start_date")) {
      Object obj = map.get("start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("end_date")) {
      Object obj = map.get("end_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndDate(null);
      }
    }
    if(map.containsKey("voucher_min_no")) {
      Object obj = map.get("voucher_min_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherMinNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucher_max_no")) {
      Object obj = map.get("voucher_max_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherMaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume_username")) {
      Object obj = map.get("volume_username");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVolumeUsername((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("box_id")) {
      Object obj = map.get("box_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBoxId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBoxId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBoxId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("location_id")) {
      Object obj = map.get("location_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLocationId((Long)obj);
        } else if(obj instanceof String) {
          entity.setLocationId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setLocationId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("warehouse_id")) {
      Object obj = map.get("warehouse_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWarehouseId((Long)obj);
        } else if(obj instanceof String) {
          entity.setWarehouseId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setWarehouseId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume_time")) {
      Object obj = map.get("volume_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVolumeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setVolumeTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVolumeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVolumeTime(null);
      }
    }
    if(map.containsKey("material_situation")) {
      Object obj = map.get("material_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_flag")) {
      Object obj = map.get("exception_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sensitive_situation")) {
      Object obj = map.get("sensitive_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_situation")) {
      Object obj = map.get("borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("directory_id")) {
      Object obj = map.get("directory_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDirectoryId((Long)obj);
        } else if(obj instanceof String) {
          entity.setDirectoryId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDirectoryId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_status")) {
      Object obj = map.get("approval_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_flow_no")) {
      Object obj = map.get("approval_flow_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalFlowNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collect_user_id")) {
      Object obj = map.get("collect_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCollectUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCollectUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("collect_user_name")) {
      Object obj = map.get("collect_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("filing_apply_user_id")) {
      Object obj = map.get("filing_apply_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFilingApplyUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setFilingApplyUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFilingApplyUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("filing_apply_user_name")) {
      Object obj = map.get("filing_apply_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFilingApplyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("filing_apply_time")) {
      Object obj = map.get("filing_apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFilingApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setFilingApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setFilingApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFilingApplyTime(null);
      }
    }
    if(map.containsKey("sign_no")) {
      Object obj = map.get("sign_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signer")) {
      Object obj = map.get("signer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSigner((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_time")) {
      Object obj = map.get("sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSignTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignTime(null);
      }
    }
    if(map.containsKey("collect_time")) {
      Object obj = map.get("collect_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCollectTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCollectTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCollectTime(null);
      }
    }
    if(map.containsKey("filing_time")) {
      Object obj = map.get("filing_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFilingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setFilingTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setFilingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFilingTime(null);
      }
    }
    if(map.containsKey("accounting_year")) {
      Object obj = map.get("accounting_year");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingYear((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountingYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAccountingYear(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("file_count")) {
      Object obj = map.get("file_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFileCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setFileCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFileCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("approval_business_key")) {
      Object obj = map.get("approval_business_key");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalBusinessKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_pending_user_id")) {
      Object obj = map.get("approval_pending_user_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalPendingUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_process_info")) {
      Object obj = map.get("approval_process_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalProcessInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_reject_flag")) {
      Object obj = map.get("approval_reject_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRejectFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_reject_remark")) {
      Object obj = map.get("approval_reject_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRejectRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_reject_time")) {
      Object obj = map.get("approval_reject_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApprovalRejectTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApprovalRejectTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApprovalRejectTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApprovalRejectTime(null);
      }
    }
    if(map.containsKey("filing_no")) {
      Object obj = map.get("filing_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFilingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tags")) {
      Object obj = map.get("tags");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTags((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("destroy_time")) {
      Object obj = map.get("destroy_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDestroyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDestroyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDestroyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDestroyTime(null);
      }
    }
    if(map.containsKey("outbound_type")) {
      Object obj = map.get("outbound_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOutboundType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custody_type")) {
      Object obj = map.get("custody_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustodyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custody_year")) {
      Object obj = map.get("custody_year");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCustodyYear((Long)obj);
        } else if(obj instanceof String) {
          entity.setCustodyYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCustodyYear(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("outsourcer_id")) {
      Object obj = map.get("outsourcer_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOutsourcerId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOutsourcerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOutsourcerId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("outsourcer_location")) {
      Object obj = map.get("outsourcer_location");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOutsourcerLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custody_expire")) {
      Object obj = map.get("custody_expire");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCustodyExpire(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCustodyExpire((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCustodyExpire(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCustodyExpire(null);
      }
    }
    if(map.containsKey("config_archive_type_no")) {
      Object obj = map.get("config_archive_type_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfigArchiveTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_rejecter")) {
      Object obj = map.get("approval_rejecter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRejecter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("increase_no")) {
      Object obj = map.get("increase_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIncreaseNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deleted")) {
      Object obj = map.get("deleted");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setDeleted((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setDeleted(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("storage_time")) {
      Object obj = map.get("storage_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStorageTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStorageTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStorageTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStorageTime(null);
      }
    }
    if(map.containsKey("storage_operator")) {
      Object obj = map.get("storage_operator");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStorageOperator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outbound_flag")) {
      Object obj = map.get("outbound_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOutboundFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outbound_reason")) {
      Object obj = map.get("outbound_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOutboundReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outbound_time")) {
      Object obj = map.get("outbound_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOutboundTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOutboundTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOutboundTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOutboundTime(null);
      }
    }
    if(map.containsKey("outbound_operater")) {
      Object obj = map.get("outbound_operater");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOutboundOperater((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_borrow_situation")) {
      Object obj = map.get("paper_borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperBorrowSituation((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
