package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-09-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class VolumeAppraisalApply implements Serializable {

  private static final long serialVersionUID=1L;

  private String businessNo;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime year;

  private String volumeCount;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime appraisalFinishTime;

  private String remark;

  private String approvalBusinessKey;

  private String approvalPendingUserId;

  private String approvalProcessInfo;

  private String approvalRejectFlag;

  private String approvalRejectRemark;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime approvalRejectTime;

  private String approvalStatus;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String approvalFlowNo;

  private String approvalRejecter;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("business_no", businessNo);
      map.put("year", BocpGenUtils.toTimestamp(year));
      map.put("volume_count", volumeCount);
      map.put("appraisal_finish_time", BocpGenUtils.toTimestamp(appraisalFinishTime));
      map.put("remark", remark);
      map.put("approval_business_key", approvalBusinessKey);
      map.put("approval_pending_user_id", approvalPendingUserId);
      map.put("approval_process_info", approvalProcessInfo);
      map.put("approval_reject_flag", approvalRejectFlag);
      map.put("approval_reject_remark", approvalRejectRemark);
      map.put("approval_reject_time", BocpGenUtils.toTimestamp(approvalRejectTime));
      map.put("approval_status", approvalStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("approval_flow_no", approvalFlowNo);
      map.put("approval_rejecter", approvalRejecter);
      return map;
  }

  public static VolumeAppraisalApply fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    VolumeAppraisalApply entity = new VolumeAppraisalApply();
    if(map.containsKey("business_no")) {
      Object obj = map.get("business_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setYear(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setYear((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setYear(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setYear(null);
      }
    }
    if(map.containsKey("volume_count")) {
      Object obj = map.get("volume_count");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVolumeCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appraisal_finish_time")) {
      Object obj = map.get("appraisal_finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAppraisalFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAppraisalFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAppraisalFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAppraisalFinishTime(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_business_key")) {
      Object obj = map.get("approval_business_key");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalBusinessKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_pending_user_id")) {
      Object obj = map.get("approval_pending_user_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalPendingUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_process_info")) {
      Object obj = map.get("approval_process_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalProcessInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_reject_flag")) {
      Object obj = map.get("approval_reject_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRejectFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_reject_remark")) {
      Object obj = map.get("approval_reject_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRejectRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_reject_time")) {
      Object obj = map.get("approval_reject_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApprovalRejectTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApprovalRejectTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApprovalRejectTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApprovalRejectTime(null);
      }
    }
    if(map.containsKey("approval_status")) {
      Object obj = map.get("approval_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_flow_no")) {
      Object obj = map.get("approval_flow_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalFlowNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_rejecter")) {
      Object obj = map.get("approval_rejecter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRejecter((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
