package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 档案规则Class
 * </p>
 *
 * @author ultraman
 * @since 2021-09-17
 */
public enum ArchiveRuleClass {

    CLASS("class", "class");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ArchiveRuleClass(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ArchiveRuleClass fromCode(String code){
        switch(code) {
            case "class":
                return CLASS;
            default:
                return null;
        }
    }
}
