package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 出库原因
 * </p>
 *
 * @author ultraman
 * @since 2021-09-17
 */
public enum OutboundType {

    BORROW("borrow", "借阅出库"),
    APPRAISAL("appraisal", "鉴定出库"),
    TRANSFER("transfer", "转移出库"),
    BACK("back", "档案退回"),
    NONE("none", "无"),
    MANUAL("manual", "手动出库");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OutboundType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OutboundType fromCode(String code){
        switch(code) {
            case "borrow":
                return BORROW;
            case "appraisal":
                return APPRAISAL;
            case "transfer":
                return TRANSFER;
            case "back":
                return BACK;
            case "none":
                return NONE;
            case "manual":
                return MANUAL;
            default:
                return null;
        }
    }
}
