package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 资料规则Class
 * </p>
 *
 * @author ultraman
 * @since 2021-10-18
 */
public enum AccountRuleClass {

    RULE_CHECK_DEMO("ruleCheckDemo", "资料演示规则"),
    RULE_CHECK_SOURCE_FILE("ruleCheckSourceFile", "源文件校验规则");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AccountRuleClass(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountRuleClass fromCode(String code){
        switch(code) {
            case "ruleCheckDemo":
                return RULE_CHECK_DEMO;
            case "ruleCheckSourceFile":
                return RULE_CHECK_SOURCE_FILE;
            default:
                return null;
        }
    }
}
