package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 保管类型
 * </p>
 *
 * @author ultraman
 * @since 2021-10-18
 */
public enum CustodyType {

    INBOUND("inbound", "内部库房保管"),
    OUTBOUND("outbound", "外包商保管");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CustodyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CustodyType fromCode(String code){
        switch(code) {
            case "inbound":
                return INBOUND;
            case "outbound":
                return OUTBOUND;
            default:
                return null;
        }
    }
}
