package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 档案异常类型(inner开头是内部 external开头是外部)
 * </p>
 *
 * @author ultraman
 * @since 2021-10-18
 */
public enum ExceptionType {

    INNER_NOT_HAS_RELATION("inner_not_has_relation", "关系未挂接"),
    INNER_NOT_FOUND_ACCOUNT_DATA_TYPE("inner_not_found_account_data_type", "未找到会计资料类型"),
    INNER_FILE_ERROR("inner_file_error", "文件加密转储失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExceptionType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExceptionType fromCode(String code){
        switch(code) {
            case "inner_not_has_relation":
                return INNER_NOT_HAS_RELATION;
            case "inner_not_found_account_data_type":
                return INNER_NOT_FOUND_ACCOUNT_DATA_TYPE;
            case "inner_file_error":
                return INNER_FILE_ERROR;
            default:
                return null;
        }
    }
}
