package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 组合校验项
 * </p>
 *
 * @author ultraman
 * @since 2021-11-01
 */
public enum CombinationCheck {

    TENANT_ID("tenant_id", "租户维度"),
    ORG_ID("org_id", "公司维度"),
    ACCOUNTING_PERIOD("accounting_period", "会计期间");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CombinationCheck(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CombinationCheck fromCode(String code){
        switch(code) {
            case "tenant_id":
                return TENANT_ID;
            case "org_id":
                return ORG_ID;
            case "accounting_period":
                return ACCOUNTING_PERIOD;
            default:
                return null;
        }
    }
}
