package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-11-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BaseVoucher implements Serializable {

  private static final long serialVersionUID=1L;

  private String voucherNo;

  private Long companyId;

  private String companyCode;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String companyName;

  private String companyTaxNo;

  private Long imageCount;

  private Long volumeId;

  private String origSystem;

  private String sensitiveFlag;

  private String virtualFlag;

  private String indexStatus;

  private String status;

  private String exceptionFlag;

  private String warningFlag;

  private String borrowStatus;

  private String materialStatus;

  private String materialSituation;

  private String type;

  private String imgUrl;

  private Long orgId;

  private String sensitiveSituation;

  private String borrowSituation;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingPeriod;

  private Long accountDataTypeId;

  private String accountDataTypeName;

  private String accountDataTypeNo;

  private Long archiveTypeId;

  private String archiveNo;

  private String archiveTypeName;

  private String businessType;

  private Long sortingUserId;

  private String sortingUserName;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sortingTime;

  private String tags;

  private Long filingApplyUserId;

  private String filingApplyUserName;

  private String signNo;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signTime;

  private String signer;

  private String signStatus;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime filingTime;

  private String archiveTypeNo;

  private String exceptionInfo;

  private String custodyFormType;

  private String exceptionType;

  private String increaseNo;

  private String orgCode;

  private Long submitUserId;

  private String submitUserName;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime submitTime;

  private String isManualSort;

  private String filingBackFlag;

  private String filingBackReason;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime filingBackTime;

  private String filingBackOperater;

  private Long accountDataCount;

  private String accountSet;

  private String voucherSummary;

  private String voucherName;

  private String currency;

  private Long directoryId;

  private Long expandId;

  private String paperBorrowStatus;

  private String paperBorrowSituation;

  private Long custodyYear;

  private String cipher;

  private String encryptionMethod;

  private String encryptionStatus;

  private String encryptionKeys;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("voucher_no", voucherNo);
      map.put("company_id", companyId);
      map.put("company_code", companyCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("image_count", imageCount);
      map.put("volume_id", volumeId);
      map.put("orig_system", origSystem);
      map.put("sensitive_flag", sensitiveFlag);
      map.put("virtual_flag", virtualFlag);
      map.put("index_status", indexStatus);
      map.put("status", status);
      map.put("exception_flag", exceptionFlag);
      map.put("warning_flag", warningFlag);
      map.put("borrow_status", borrowStatus);
      map.put("material_status", materialStatus);
      map.put("material_situation", materialSituation);
      map.put("type", type);
      map.put("img_url", imgUrl);
      map.put("org_id", orgId);
      map.put("sensitive_situation", sensitiveSituation);
      map.put("borrow_situation", borrowSituation);
      map.put("accounting_period", BocpGenUtils.toTimestamp(accountingPeriod));
      map.put("account_data_type_id", accountDataTypeId);
      map.put("account_data_type_name", accountDataTypeName);
      map.put("account_data_type_no", accountDataTypeNo);
      map.put("archive_type_id", archiveTypeId);
      map.put("archive_no", archiveNo);
      map.put("archive_type_name", archiveTypeName);
      map.put("business_type", businessType);
      map.put("sorting_user_id", sortingUserId);
      map.put("sorting_user_name", sortingUserName);
      map.put("sorting_time", BocpGenUtils.toTimestamp(sortingTime));
      map.put("tags", tags);
      map.put("filing_apply_user_id", filingApplyUserId);
      map.put("filing_apply_user_name", filingApplyUserName);
      map.put("sign_no", signNo);
      map.put("sign_time", BocpGenUtils.toTimestamp(signTime));
      map.put("signer", signer);
      map.put("sign_status", signStatus);
      map.put("filing_time", BocpGenUtils.toTimestamp(filingTime));
      map.put("archive_type_no", archiveTypeNo);
      map.put("exception_info", exceptionInfo);
      map.put("custody_form_type", custodyFormType);
      map.put("exception_type", exceptionType);
      map.put("increase_no", increaseNo);
      map.put("org_code", orgCode);
      map.put("submit_user_id", submitUserId);
      map.put("submit_user_name", submitUserName);
      map.put("submit_time", BocpGenUtils.toTimestamp(submitTime));
      map.put("is_manual_sort", isManualSort);
      map.put("filing_back_flag", filingBackFlag);
      map.put("filing_back_reason", filingBackReason);
      map.put("filing_back_time", BocpGenUtils.toTimestamp(filingBackTime));
      map.put("filing_back_operater", filingBackOperater);
      map.put("account_data_count", accountDataCount);
      map.put("account_set", accountSet);
      map.put("voucher_summary", voucherSummary);
      map.put("voucher_name", voucherName);
      map.put("currency", currency);
      map.put("directory_id", directoryId);
      map.put("expand_id", expandId);
      map.put("paper_borrow_status", paperBorrowStatus);
      map.put("paper_borrow_situation", paperBorrowSituation);
      map.put("custody_year", custodyYear);
      map.put("cipher", cipher);
      map.put("encryption_method", encryptionMethod);
      map.put("encryption_status", encryptionStatus);
      map.put("encryption_keys", encryptionKeys);
      return map;
  }

  public static BaseVoucher fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BaseVoucher entity = new BaseVoucher();
    if(map.containsKey("voucher_no")) {
      Object obj = map.get("voucher_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("company_code")) {
      Object obj = map.get("company_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("image_count")) {
      Object obj = map.get("image_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setImageCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setImageCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("volume_id")) {
      Object obj = map.get("volume_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVolumeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setVolumeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVolumeId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orig_system")) {
      Object obj = map.get("orig_system");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigSystem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sensitive_flag")) {
      Object obj = map.get("sensitive_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtual_flag")) {
      Object obj = map.get("virtual_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVirtualFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("index_status")) {
      Object obj = map.get("index_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIndexStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_flag")) {
      Object obj = map.get("exception_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_flag")) {
      Object obj = map.get("warning_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_status")) {
      Object obj = map.get("borrow_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material_status")) {
      Object obj = map.get("material_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material_situation")) {
      Object obj = map.get("material_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sensitive_situation")) {
      Object obj = map.get("sensitive_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_situation")) {
      Object obj = map.get("borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accounting_period")) {
      Object obj = map.get("accounting_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingPeriod(null);
      }
    }
    if(map.containsKey("account_data_type_id")) {
      Object obj = map.get("account_data_type_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountDataTypeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountDataTypeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAccountDataTypeId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("account_data_type_name")) {
      Object obj = map.get("account_data_type_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_data_type_no")) {
      Object obj = map.get("account_data_type_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("archive_type_id")) {
      Object obj = map.get("archive_type_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setArchiveTypeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setArchiveTypeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setArchiveTypeId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("archive_no")) {
      Object obj = map.get("archive_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setArchiveNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("archive_type_name")) {
      Object obj = map.get("archive_type_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setArchiveTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sorting_user_id")) {
      Object obj = map.get("sorting_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSortingUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSortingUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSortingUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sorting_user_name")) {
      Object obj = map.get("sorting_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSortingUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sorting_time")) {
      Object obj = map.get("sorting_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSortingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSortingTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSortingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSortingTime(null);
      }
    }
    if(map.containsKey("tags")) {
      Object obj = map.get("tags");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTags((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("filing_apply_user_id")) {
      Object obj = map.get("filing_apply_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFilingApplyUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setFilingApplyUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFilingApplyUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("filing_apply_user_name")) {
      Object obj = map.get("filing_apply_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFilingApplyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_no")) {
      Object obj = map.get("sign_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_time")) {
      Object obj = map.get("sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSignTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignTime(null);
      }
    }
    if(map.containsKey("signer")) {
      Object obj = map.get("signer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSigner((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_status")) {
      Object obj = map.get("sign_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("filing_time")) {
      Object obj = map.get("filing_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFilingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setFilingTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setFilingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFilingTime(null);
      }
    }
    if(map.containsKey("archive_type_no")) {
      Object obj = map.get("archive_type_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setArchiveTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custody_form_type")) {
      Object obj = map.get("custody_form_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustodyFormType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_type")) {
      Object obj = map.get("exception_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("increase_no")) {
      Object obj = map.get("increase_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIncreaseNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submit_user_id")) {
      Object obj = map.get("submit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSubmitUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSubmitUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSubmitUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("submit_user_name")) {
      Object obj = map.get("submit_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submit_time")) {
      Object obj = map.get("submit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSubmitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSubmitTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSubmitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSubmitTime(null);
      }
    }
    if(map.containsKey("is_manual_sort")) {
      Object obj = map.get("is_manual_sort");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsManualSort((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("filing_back_flag")) {
      Object obj = map.get("filing_back_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFilingBackFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("filing_back_reason")) {
      Object obj = map.get("filing_back_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFilingBackReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("filing_back_time")) {
      Object obj = map.get("filing_back_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFilingBackTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setFilingBackTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setFilingBackTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFilingBackTime(null);
      }
    }
    if(map.containsKey("filing_back_operater")) {
      Object obj = map.get("filing_back_operater");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFilingBackOperater((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_data_count")) {
      Object obj = map.get("account_data_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountDataCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountDataCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAccountDataCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("account_set")) {
      Object obj = map.get("account_set");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountSet((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucher_summary")) {
      Object obj = map.get("voucher_summary");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherSummary((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucher_name")) {
      Object obj = map.get("voucher_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("directory_id")) {
      Object obj = map.get("directory_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDirectoryId((Long)obj);
        } else if(obj instanceof String) {
          entity.setDirectoryId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDirectoryId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("expand_id")) {
      Object obj = map.get("expand_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpandId((Long)obj);
        } else if(obj instanceof String) {
          entity.setExpandId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setExpandId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paper_borrow_status")) {
      Object obj = map.get("paper_borrow_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperBorrowStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_borrow_situation")) {
      Object obj = map.get("paper_borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperBorrowSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custody_year")) {
      Object obj = map.get("custody_year");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCustodyYear((Long)obj);
        } else if(obj instanceof String) {
          entity.setCustodyYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCustodyYear(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cipher")) {
      Object obj = map.get("cipher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("encryption_method")) {
      Object obj = map.get("encryption_method");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEncryptionMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("encryption_status")) {
      Object obj = map.get("encryption_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEncryptionStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("encryption_keys")) {
      Object obj = map.get("encryption_keys");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEncryptionKeys((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
