package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 鉴定类型
 * </p>
 *
 * @author ultraman
 * @since 2021-11-15
 */
public enum AppraisalType {

    RENEW("renew", "续存"),
    DESTROY("destroy", "销毁");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AppraisalType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AppraisalType fromCode(String code){
        switch(code) {
            case "renew":
                return RENEW;
            case "destroy":
                return DESTROY;
            default:
                return null;
        }
    }
}
