package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 借阅申请信息
 * </p>
 *
 * @author ultraman
 * @since 2021-11-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BorrowApplyInfo implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 公司Id
   */
  private Long companyId;

  /**
   * 组织Id
   */
  private Long orgId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 状态
   */
  private String status;

  /**
   * 借阅工作流编号
   */
  private String flowNo;

  /**
   * 借阅员工编号
   */
  private String borrowUserCode;

  /**
   * 借阅人名字
   */
  private String borrowUsername;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 部门名称
   */
  private String departmentName;

  /**
   * 借阅人电话
   */
  private String borrowPhone;

  /**
   * 借阅人邮箱
   */
  private String borrowMail;

  /**
   * 职位
   */
  private String position;

  /**
   * 借阅开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyStartTime;

  /**
   * 借阅结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyEndTime;

  /**
   * 借阅事由
   */
  private String reason;

  /**
   * 借阅内容
   */
  private String content;

  /**
   * 档案类型
   */
  private String fileType;

  /**
   * 借阅类型(正常/续借)
   */
  private String type;

  /**
   * 邮寄地址
   */
  private String address;

  /**
   * 备注
   */
  private String remark;

  /**
   * 授权时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authTime;

  /**
   * 最后授权方式(0-无水印 1-有水印 2-下载源文件 3-下载图像 4-打印 5-借阅实物原件) 多个以,分割
   */
  private String authTypes;

  /**
   * 最后授权人名称
   */
  private String authUsername;

  /**
   * 最后借出登记时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime borrowTime;

  /**
   * 最后归还时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime returnTime;

  /**
   * 最后借出人
   */
  private String borrowLendUsername;

  /**
   * 是否遗失
   */
  private String loseFlag;

  /**
   * 是否逾期
   */
  private String overdueFlag;

  /**
   * 借出情况
   */
  private String borrowSituation;

  /**
   * 借阅时长
   */
  private String borrowDuration;

  /**
   * 借阅员工Id
   */
  private Long borrowUserId;

  /**
   * 审批业务唯一键
   */
  private String approvalBusinessKey;

  /**
   * 当前待审批人userId(审批通过或驳回都清空，后续也可能为多个人)
   */
  private String approvalPendingUserId;

  /**
   * 审批流程定义的审批节点信息(数据结构:[{"user_id":1001,"user_name":"zhangsan","priority":0])
   */
  private String approvalProcessInfo;

  /**
   * 审批驳回标记
   */
  private String approvalRejectFlag;

  /**
   * 审批驳回原因
   */
  private String approvalRejectRemark;

  /**
   * 审核状态
   */
  private String approvalStatus;

  /**
   * 审批驳回时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime approvalRejectTime;

  /**
   * 审批拒绝者
   */
  private String approvalRejecter;

  /**
   * 借阅渠道
   */
  private String channel;

  /**
   * 借阅编号
   */
  private String borrowNo;

  /**
   * 授权用户编号
   */
  private Long authUserId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("company_id", companyId);
      map.put("org_id", orgId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("status", status);
      map.put("flow_no", flowNo);
      map.put("borrow_user_code", borrowUserCode);
      map.put("borrow_username", borrowUsername);
      map.put("company_name", companyName);
      map.put("department_name", departmentName);
      map.put("borrow_phone", borrowPhone);
      map.put("borrow_mail", borrowMail);
      map.put("position", position);
      map.put("apply_start_time", BocpGenUtils.toTimestamp(applyStartTime));
      map.put("apply_end_time", BocpGenUtils.toTimestamp(applyEndTime));
      map.put("reason", reason);
      map.put("content", content);
      map.put("file_type", fileType);
      map.put("type", type);
      map.put("address", address);
      map.put("remark", remark);
      map.put("auth_time", BocpGenUtils.toTimestamp(authTime));
      map.put("auth_types", authTypes);
      map.put("auth_username", authUsername);
      map.put("borrow_time", BocpGenUtils.toTimestamp(borrowTime));
      map.put("return_time", BocpGenUtils.toTimestamp(returnTime));
      map.put("borrow_lend_username", borrowLendUsername);
      map.put("lose_flag", loseFlag);
      map.put("overdue_flag", overdueFlag);
      map.put("borrow_situation", borrowSituation);
      map.put("borrow_duration", borrowDuration);
      map.put("borrow_user_id", borrowUserId);
      map.put("approval_business_key", approvalBusinessKey);
      map.put("approval_pending_user_id", approvalPendingUserId);
      map.put("approval_process_info", approvalProcessInfo);
      map.put("approval_reject_flag", approvalRejectFlag);
      map.put("approval_reject_remark", approvalRejectRemark);
      map.put("approval_status", approvalStatus);
      map.put("approval_reject_time", BocpGenUtils.toTimestamp(approvalRejectTime));
      map.put("approval_rejecter", approvalRejecter);
      map.put("channel", channel);
      map.put("borrow_no", borrowNo);
      map.put("auth_user_id", authUserId);
      return map;
  }

  public static BorrowApplyInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BorrowApplyInfo entity = new BorrowApplyInfo();
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flow_no")) {
      Object obj = map.get("flow_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFlowNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_user_code")) {
      Object obj = map.get("borrow_user_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowUserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_username")) {
      Object obj = map.get("borrow_username");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowUsername((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("department_name")) {
      Object obj = map.get("department_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_phone")) {
      Object obj = map.get("borrow_phone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_mail")) {
      Object obj = map.get("borrow_mail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowMail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("position")) {
      Object obj = map.get("position");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPosition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_start_time")) {
      Object obj = map.get("apply_start_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplyStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyStartTime(null);
      }
    }
    if(map.containsKey("apply_end_time")) {
      Object obj = map.get("apply_end_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyEndTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplyEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyEndTime(null);
      }
    }
    if(map.containsKey("reason")) {
      Object obj = map.get("reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("content")) {
      Object obj = map.get("content");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_type")) {
      Object obj = map.get("file_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("address")) {
      Object obj = map.get("address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_time")) {
      Object obj = map.get("auth_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthTime(null);
      }
    }
    if(map.containsKey("auth_types")) {
      Object obj = map.get("auth_types");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthTypes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_username")) {
      Object obj = map.get("auth_username");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthUsername((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_time")) {
      Object obj = map.get("borrow_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBorrowTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBorrowTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBorrowTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBorrowTime(null);
      }
    }
    if(map.containsKey("return_time")) {
      Object obj = map.get("return_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReturnTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReturnTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReturnTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReturnTime(null);
      }
    }
    if(map.containsKey("borrow_lend_username")) {
      Object obj = map.get("borrow_lend_username");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowLendUsername((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lose_flag")) {
      Object obj = map.get("lose_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLoseFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("overdue_flag")) {
      Object obj = map.get("overdue_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOverdueFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_situation")) {
      Object obj = map.get("borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_duration")) {
      Object obj = map.get("borrow_duration");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowDuration((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_user_id")) {
      Object obj = map.get("borrow_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBorrowUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBorrowUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBorrowUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("approval_business_key")) {
      Object obj = map.get("approval_business_key");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalBusinessKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_pending_user_id")) {
      Object obj = map.get("approval_pending_user_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalPendingUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_process_info")) {
      Object obj = map.get("approval_process_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalProcessInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_reject_flag")) {
      Object obj = map.get("approval_reject_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRejectFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_reject_remark")) {
      Object obj = map.get("approval_reject_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRejectRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_status")) {
      Object obj = map.get("approval_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_reject_time")) {
      Object obj = map.get("approval_reject_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApprovalRejectTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApprovalRejectTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApprovalRejectTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApprovalRejectTime(null);
      }
    }
    if(map.containsKey("approval_rejecter")) {
      Object obj = map.get("approval_rejecter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRejecter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_no")) {
      Object obj = map.get("borrow_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_user_id")) {
      Object obj = map.get("auth_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAuthUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAuthUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }
}
