package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 系统配置
 * </p>
 *
 * @author ultraman
 * @since 2021-11-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ConfigSettings implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 是否默认
   */
  private String isDefault;

  /**
   * 是否启用
   */
  private String enable;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 此配置生效范围
   */
  private String range;

  /**
   * 校验重复字段
   */
  private String repeatField;

  /**
   * 租户ID
   */
  private Long tenant;

  /**
   * 生效组织id
   */
  private Long orgId;

  /**
   * 生效组织名称
   */
  private String orgName;

  /**
   * 保存年限
   */
  private Long term;

  /**
   * 提交类型
   */
  private String submitType;

  /**
   * 异常能否提交
   */
  private String expFlag;

  /**
   * 分册是否允许凭证断号
   */
  private String volumnContinuative;

  /**
   * 入库是否允许会计期间凭证断号
   */
  private String locationNoContinuative;

  /**
   * 入库是否允许会计期间册次号不连续
   */
  private String locationOrderContinuative;

  /**
   * 下载的发票类型
   */
  private String downloadInvoiceType;

  /**
   * 开启的审批流代码
   */
  private String bpmCode;

  /**
   * 文件上传允许类型
   */
  private String uploadFileType;

  /**
   * 文件上传最大数量
   */
  private Long uploadFileCount;

  /**
   * 文件上传最大Size(MB)(不能超过系统最大200MB)
   */
  private Long uploadFileSize;

  /**
   * 有水印查看资源码
   */
  private String waterMarkResourceCode;

  /**
   * 是否加密
   */
  private String encryptionFlag;

  /**
   * 是否转储
   */
  private String dumpFlag;

  /**
   * 加密方式
   */
  private String encryptionMethod;

  /**
   * 借阅外链盐
   */
  private String salt;

  /**
   * 分册是否填写册次号
   */
  private String checkVolumeNoFlag;

  /**
   * 四性检测压缩包类型 xml 、json 格式
   */
  private String checkNaturesZipType;

  /**
   * 目录导出单个包数量
   */
  private Long directoryExportSize;

  /**
   * 档案室或仓库适用全部组织开关
   */
  private String wlUseAllOrg;

  /**
   * 组合校验项
   */
  private String combinationCheck;

  /**
   * 分册校验项
   */
  @TableField("volumeCheck")
  private String volumeCheck;

  /**
   * 校验组织编号
   */
  private String checkOrgId;

  /**
   * 是否打开审批流
   */
  private String openBpm;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("is_default", isDefault);
      map.put("enable", enable);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("range", range);
      map.put("repeat_field", repeatField);
      map.put("tenant", tenant);
      map.put("org_id", orgId);
      map.put("org_name", orgName);
      map.put("term", term);
      map.put("submit_type", submitType);
      map.put("exp_flag", expFlag);
      map.put("volumn_continuative", volumnContinuative);
      map.put("location_no_continuative", locationNoContinuative);
      map.put("location_order_continuative", locationOrderContinuative);
      map.put("download_invoice_type", downloadInvoiceType);
      map.put("bpm_code", bpmCode);
      map.put("upload_file_type", uploadFileType);
      map.put("upload_file_count", uploadFileCount);
      map.put("upload_file_size", uploadFileSize);
      map.put("water_mark_resource_code", waterMarkResourceCode);
      map.put("encryption_flag", encryptionFlag);
      map.put("dump_flag", dumpFlag);
      map.put("encryption_method", encryptionMethod);
      map.put("salt", salt);
      map.put("check_volume_no_flag", checkVolumeNoFlag);
      map.put("check_natures_zip_type", checkNaturesZipType);
      map.put("directory_export_size", directoryExportSize);
      map.put("wl_use_all_org", wlUseAllOrg);
      map.put("combination_check", combinationCheck);
      map.put("volumeCheck", volumeCheck);
      map.put("check_org_id", checkOrgId);
      map.put("open_bpm", openBpm);
      return map;
  }

  public static ConfigSettings fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ConfigSettings entity = new ConfigSettings();
    if(map.containsKey("is_default")) {
      Object obj = map.get("is_default");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsDefault((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("enable")) {
      Object obj = map.get("enable");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("range")) {
      Object obj = map.get("range");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRange((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("repeat_field")) {
      Object obj = map.get("repeat_field");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRepeatField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant")) {
      Object obj = map.get("tenant");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenant((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenant(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenant(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("term")) {
      Object obj = map.get("term");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTerm((Long)obj);
        } else if(obj instanceof String) {
          entity.setTerm(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTerm(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("submit_type")) {
      Object obj = map.get("submit_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exp_flag")) {
      Object obj = map.get("exp_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volumn_continuative")) {
      Object obj = map.get("volumn_continuative");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVolumnContinuative((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("location_no_continuative")) {
      Object obj = map.get("location_no_continuative");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLocationNoContinuative((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("location_order_continuative")) {
      Object obj = map.get("location_order_continuative");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLocationOrderContinuative((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("download_invoice_type")) {
      Object obj = map.get("download_invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bpm_code")) {
      Object obj = map.get("bpm_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBpmCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("upload_file_type")) {
      Object obj = map.get("upload_file_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUploadFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("upload_file_count")) {
      Object obj = map.get("upload_file_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUploadFileCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setUploadFileCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUploadFileCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("upload_file_size")) {
      Object obj = map.get("upload_file_size");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUploadFileSize((Long)obj);
        } else if(obj instanceof String) {
          entity.setUploadFileSize(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUploadFileSize(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("water_mark_resource_code")) {
      Object obj = map.get("water_mark_resource_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWaterMarkResourceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("encryption_flag")) {
      Object obj = map.get("encryption_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEncryptionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dump_flag")) {
      Object obj = map.get("dump_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDumpFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("encryption_method")) {
      Object obj = map.get("encryption_method");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEncryptionMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salt")) {
      Object obj = map.get("salt");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_volume_no_flag")) {
      Object obj = map.get("check_volume_no_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckVolumeNoFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_natures_zip_type")) {
      Object obj = map.get("check_natures_zip_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckNaturesZipType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("directory_export_size")) {
      Object obj = map.get("directory_export_size");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDirectoryExportSize((Long)obj);
        } else if(obj instanceof String) {
          entity.setDirectoryExportSize(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDirectoryExportSize(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("wl_use_all_org")) {
      Object obj = map.get("wl_use_all_org");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWlUseAllOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("combination_check")) {
      Object obj = map.get("combination_check");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCombinationCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volumeCheck")) {
      Object obj = map.get("volumeCheck");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVolumeCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_org_id")) {
      Object obj = map.get("check_org_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckOrgId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("open_bpm")) {
      Object obj = map.get("open_bpm");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOpenBpm((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
