package com.xforceplus.elephantarchives.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 原始单据
 * </p>
 *
 * @author ultraman
 * @since 2021-11-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OriginalBill implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 单据号
   */
  private String billNo;

  /**
   * 单据含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  private BigDecimal taxAmount;

  /**
   * 预警状态
   */
  private String warningFlag;

  /**
   * 异常信息
   */
  private String exceptionInfo;

  /**
   * 公司id
   */
  private Long companyId;

  /**
   * 公司代码
   */
  private String companyCode;

  /**
   * 系统来源
   */
  private String origSystem;

  /**
   * 借阅状态
   */
  private String borrowStatus;

  /**
   * 是否敏感件
   */
  private String sensitiveFlag;

  /**
   * 实物状态
   */
  private String materialStatus;

  /**
   * 业务类型
   */
  private String businessType;

  /**
   * 唯一标识
   */
  private String billUniqueFlag;

  /**
   * 流水号
   */
  private String serialNumber;

  /**
   * 分摊比例
   */
  private BigDecimal shareScale;

  /**
   * 是否占用
   */
  private String occupationFlag;

  /**
   * 预付款状态
   */
  private String prepaymentStatus;

  /**
   * 提单人
   */
  private String billCreateUser;

  /**
   * 是否遗失
   */
  private String loseFlag;

  /**
   * 是否异常
   */
  private String exceptionFlag;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 组织id
   */
  private Long orgId;

  /**
   * 提单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billCreateTime;

  /**
   * 单据类型
   */
  private String type;

  /**
   * 单据小类
   */
  private String subType;

  /**
   * 单据类型代码
   */
  private String billTypeCode;

  /**
   * 订单号
   */
  private String orderNo;

  /**
   * 实物情况
   */
  private String materialSituation;

  /**
   * 敏感情况
   */
  private String sensitiveSituation;

  /**
   * img url
   */
  private String imgUrl;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 借阅情况
   */
  private String borrowSituation;

  /**
   * 整理状态
   */
  private String sortingStatus;

  /**
   * 资料类型id
   */
  private Long accountDataTypeId;

  /**
   * 资料类型name
   */
  private String accountDataTypeName;

  /**
   * 资料类型no
   */
  private String accountDataTypeNo;

  /**
   * 币种
   */
  private String currency;

  /**
   * 保管形式
   */
  private String custodyFormType;

  /**
   * 异常类型
   */
  private String exceptionType;

  /**
   * 纸质借阅情况
   */
  private String paperBorrowSituation;

  /**
   * 纸质借阅状态
   */
  private String paperBorrowStatus;

  /**
   * 组织代码
   */
  private String orgCode;

  /**
   * 保管年限
   */
  private Long custodyYear;

  /**
   * 密文
   */
  private String cipher;

  /**
   * 加密方式
   */
  private String encryptionMethod;

  /**
   * 加密状态
   */
  private String encryptionStatus;

  /**
   * 加密字段
   */
  private String encryptionKeys;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bill_no", billNo);
      map.put("amount_with_tax", amountWithTax);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("warning_flag", warningFlag);
      map.put("exception_info", exceptionInfo);
      map.put("company_id", companyId);
      map.put("company_code", companyCode);
      map.put("orig_system", origSystem);
      map.put("borrow_status", borrowStatus);
      map.put("sensitive_flag", sensitiveFlag);
      map.put("material_status", materialStatus);
      map.put("business_type", businessType);
      map.put("bill_unique_flag", billUniqueFlag);
      map.put("serial_number", serialNumber);
      map.put("share_scale", shareScale);
      map.put("occupation_flag", occupationFlag);
      map.put("prepayment_status", prepaymentStatus);
      map.put("bill_create_user", billCreateUser);
      map.put("lose_flag", loseFlag);
      map.put("exception_flag", exceptionFlag);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("org_id", orgId);
      map.put("bill_create_time", BocpGenUtils.toTimestamp(billCreateTime));
      map.put("type", type);
      map.put("sub_type", subType);
      map.put("bill_type_code", billTypeCode);
      map.put("order_no", orderNo);
      map.put("material_situation", materialSituation);
      map.put("sensitive_situation", sensitiveSituation);
      map.put("img_url", imgUrl);
      map.put("company_name", companyName);
      map.put("borrow_situation", borrowSituation);
      map.put("sorting_status", sortingStatus);
      map.put("account_data_type_id", accountDataTypeId);
      map.put("account_data_type_name", accountDataTypeName);
      map.put("account_data_type_no", accountDataTypeNo);
      map.put("currency", currency);
      map.put("custody_form_type", custodyFormType);
      map.put("exception_type", exceptionType);
      map.put("paper_borrow_situation", paperBorrowSituation);
      map.put("paper_borrow_status", paperBorrowStatus);
      map.put("org_code", orgCode);
      map.put("custody_year", custodyYear);
      map.put("cipher", cipher);
      map.put("encryption_method", encryptionMethod);
      map.put("encryption_status", encryptionStatus);
      map.put("encryption_keys", encryptionKeys);
      return map;
  }

  public static OriginalBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OriginalBill entity = new OriginalBill();
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("warning_flag")) {
      Object obj = map.get("warning_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("company_code")) {
      Object obj = map.get("company_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orig_system")) {
      Object obj = map.get("orig_system");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigSystem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_status")) {
      Object obj = map.get("borrow_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sensitive_flag")) {
      Object obj = map.get("sensitive_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material_status")) {
      Object obj = map.get("material_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_unique_flag")) {
      Object obj = map.get("bill_unique_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillUniqueFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSerialNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("share_scale")) {
      Object obj = map.get("share_scale");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareScale((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareScale(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareScale(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setShareScale(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareScale(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("occupation_flag")) {
      Object obj = map.get("occupation_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOccupationFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepayment_status")) {
      Object obj = map.get("prepayment_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_create_user")) {
      Object obj = map.get("bill_create_user");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lose_flag")) {
      Object obj = map.get("lose_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLoseFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_flag")) {
      Object obj = map.get("exception_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bill_create_time")) {
      Object obj = map.get("bill_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBillCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBillCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillCreateTime(null);
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sub_type")) {
      Object obj = map.get("sub_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type_code")) {
      Object obj = map.get("bill_type_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material_situation")) {
      Object obj = map.get("material_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sensitive_situation")) {
      Object obj = map.get("sensitive_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_situation")) {
      Object obj = map.get("borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sorting_status")) {
      Object obj = map.get("sorting_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSortingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_data_type_id")) {
      Object obj = map.get("account_data_type_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountDataTypeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountDataTypeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAccountDataTypeId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("account_data_type_name")) {
      Object obj = map.get("account_data_type_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_data_type_no")) {
      Object obj = map.get("account_data_type_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custody_form_type")) {
      Object obj = map.get("custody_form_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustodyFormType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_type")) {
      Object obj = map.get("exception_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_borrow_situation")) {
      Object obj = map.get("paper_borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperBorrowSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_borrow_status")) {
      Object obj = map.get("paper_borrow_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperBorrowStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custody_year")) {
      Object obj = map.get("custody_year");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCustodyYear((Long)obj);
        } else if(obj instanceof String) {
          entity.setCustodyYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCustodyYear(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cipher")) {
      Object obj = map.get("cipher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("encryption_method")) {
      Object obj = map.get("encryption_method");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEncryptionMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("encryption_status")) {
      Object obj = map.get("encryption_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEncryptionStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("encryption_keys")) {
      Object obj = map.get("encryption_keys");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEncryptionKeys((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
