package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 规则编号
 * </p>
 *
 * @author ultraman
 * @since 2021-11-16
 */
public enum ExceptionRuleCode {

    A1003("A1003", "源文件校验规则"),
    R1001("R1001", "档案类型校验规则"),
    R1002("R1002", "档案下异常资料校验规则"),
    R1003("R1003", "档案下预警资料校验规则"),
    A1004("A1004", "资料演示规则"),
    R1004("R1004", "档案演示规则"),
    R1005("R1005", "手工凭证校验规则"),
    _10001("10001", "缺少会计凭证之间的关系"),
    _10002("10002", "文件加密转储失败"),
    AUTHENTICITY_ARCHIVE_CONSISTENT("authenticity_archive_consistent", "归档信息包一致性检测"),
    AUTHENTICITY_ARCHIVE_STRUCTURE("authenticity_archive_structure", "归档信息包目录结构规范性检测"),
    AUTHENTICITY_ARCHIVE_SPECIFICATION("authenticity_archive_specification", "说明文件和目录文件规范性检测"),
    AUTHENTICITY_ASSOCIATED_METADATA("authenticity_associated_metadata", "元数据是否关联内容数据"),
    AUTHENTICITY_CONTENT_CONSISTENT("authenticity_content_consistent", "电子文件内容数据的电子属性一致性检测"),
    AUTHENTICITY_METADATA_CONFORM("authenticity_metadata_conform", "设定值域的元数据项值域符合度检测"),
    AUTHENTICITY_METADATA_FORMAT("authenticity_metadata_format", "元数据项数据类型、字段格式检测"),
    AUTHENTICITY_METADATA_LENGTH("authenticity_metadata_length", "元数据项数据长度检测"),
    AUTHENTICITY_METADATA_REPEAT("authenticity_metadata_repeat", "元数据项数据重复性检测"),
    AUTHENTICITY_METADATA_SCOPE("authenticity_metadata_scope", "元数据项数据范围检测"),
    AUTHENTICITY_METADATA_SPECIAL_CHARACTERS("authenticity_metadata_specialCharacters", "元数据项数据包含特殊字符检测"),
    AVAILABILITY_ARCHIVE_CONTENT_FORMAT("availability_archive_contentFormat", "信息包中包含的内容数据格式合规性检测"),
    AVAILABILITY_CONTENT_FORMAT("availability_content_format", "内容数据格式检测"),
    AVAILABILITY_HARDWARE_ENVIRONMENT("availability_hardware_environment", "软硬件环境合规性检测"),
    AVAILABILITY_METADATA_DATABASE_RECORD("availability_metadata_databaseRecord", "目标数据库中的元数据可访问性检测"),
    AVAILABILITY_METADATA_READABILITY("availability_metadata_readability", "信息包中元数据的可读性检测"),
    INTEGRITY_ARCHIVE_DATA("integrity_archive_data", "信息包内容数据完整性检测"),
    INTEGRITY_ARCHIVE_SCOPE("integrity_archive_scope", "归档范围检测"),
    INTEGRITY_METADATA_INTEGRITY("integrity_metadata_integrity", "数据项完整性检测"),
    INTEGRITY_METADATA_MANDATORY("integrity_metadata_mandatory", "元数据必填著录项目检测");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExceptionRuleCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExceptionRuleCode fromCode(String code){
        switch(code) {
            case "A1003":
                return A1003;
            case "R1001":
                return R1001;
            case "R1002":
                return R1002;
            case "R1003":
                return R1003;
            case "A1004":
                return A1004;
            case "R1004":
                return R1004;
            case "R1005":
                return R1005;
            case "10001":
                return _10001;
            case "10002":
                return _10002;
            case "authenticity_archive_consistent":
                return AUTHENTICITY_ARCHIVE_CONSISTENT;
            case "authenticity_archive_structure":
                return AUTHENTICITY_ARCHIVE_STRUCTURE;
            case "authenticity_archive_specification":
                return AUTHENTICITY_ARCHIVE_SPECIFICATION;
            case "authenticity_associated_metadata":
                return AUTHENTICITY_ASSOCIATED_METADATA;
            case "authenticity_content_consistent":
                return AUTHENTICITY_CONTENT_CONSISTENT;
            case "authenticity_metadata_conform":
                return AUTHENTICITY_METADATA_CONFORM;
            case "authenticity_metadata_format":
                return AUTHENTICITY_METADATA_FORMAT;
            case "authenticity_metadata_length":
                return AUTHENTICITY_METADATA_LENGTH;
            case "authenticity_metadata_repeat":
                return AUTHENTICITY_METADATA_REPEAT;
            case "authenticity_metadata_scope":
                return AUTHENTICITY_METADATA_SCOPE;
            case "authenticity_metadata_specialCharacters":
                return AUTHENTICITY_METADATA_SPECIAL_CHARACTERS;
            case "availability_archive_contentFormat":
                return AVAILABILITY_ARCHIVE_CONTENT_FORMAT;
            case "availability_content_format":
                return AVAILABILITY_CONTENT_FORMAT;
            case "availability_hardware_environment":
                return AVAILABILITY_HARDWARE_ENVIRONMENT;
            case "availability_metadata_databaseRecord":
                return AVAILABILITY_METADATA_DATABASE_RECORD;
            case "availability_metadata_readability":
                return AVAILABILITY_METADATA_READABILITY;
            case "integrity_archive_data":
                return INTEGRITY_ARCHIVE_DATA;
            case "integrity_archive_scope":
                return INTEGRITY_ARCHIVE_SCOPE;
            case "integrity_metadata_integrity":
                return INTEGRITY_METADATA_INTEGRITY;
            case "integrity_metadata_mandatory":
                return INTEGRITY_METADATA_MANDATORY;
            default:
                return null;
        }
    }
}
