package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 转移操作表
 * </p>
 *
 * @author ultraman
 * @since 2021-11-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TransferOperation implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 流程编号
   */
  private String workflowNo;

  /**
   * 处理状态
   */
  private String handlerStatus;

  /**
   * 分册编号
   */
  private String volumeNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 转移后目标id
   */
  private Long targetId;

  /**
   * 原库位id
   */
  private Long originalLocationId;

  /**
   * 保管类型
   */
  private String custodyType;

  /**
   * 原目录id
   */
  private Long originalDirectoryId;

  /**
   * 目标目录id
   */
  private Long targetDirectoryId;

  /**
   * 原档案室id
   */
  private Long originalWarehouseId;

  /**
   * 处理时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime handlerTime;

  /**
   * 目标档案室id
   */
  private Long targetWarehouseId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("workflow_no", workflowNo);
      map.put("handler_status", handlerStatus);
      map.put("volume_no", volumeNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("target_id", targetId);
      map.put("original_location_id", originalLocationId);
      map.put("custody_type", custodyType);
      map.put("original_directory_id", originalDirectoryId);
      map.put("target_directory_id", targetDirectoryId);
      map.put("original_warehouse_id", originalWarehouseId);
      map.put("handler_time", BocpGenUtils.toTimestamp(handlerTime));
      map.put("target_warehouse_id", targetWarehouseId);
      return map;
  }

  public static TransferOperation fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TransferOperation entity = new TransferOperation();
    if(map.containsKey("workflow_no")) {
      Object obj = map.get("workflow_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWorkflowNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handler_status")) {
      Object obj = map.get("handler_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandlerStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume_no")) {
      Object obj = map.get("volume_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVolumeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("target_id")) {
      Object obj = map.get("target_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTargetId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTargetId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTargetId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("original_location_id")) {
      Object obj = map.get("original_location_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOriginalLocationId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOriginalLocationId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOriginalLocationId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("custody_type")) {
      Object obj = map.get("custody_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustodyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("original_directory_id")) {
      Object obj = map.get("original_directory_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOriginalDirectoryId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOriginalDirectoryId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOriginalDirectoryId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("target_directory_id")) {
      Object obj = map.get("target_directory_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTargetDirectoryId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTargetDirectoryId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTargetDirectoryId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("original_warehouse_id")) {
      Object obj = map.get("original_warehouse_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOriginalWarehouseId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOriginalWarehouseId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOriginalWarehouseId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("handler_time")) {
      Object obj = map.get("handler_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHandlerTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setHandlerTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setHandlerTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setHandlerTime(null);
      }
    }
    if(map.containsKey("target_warehouse_id")) {
      Object obj = map.get("target_warehouse_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTargetWarehouseId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTargetWarehouseId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTargetWarehouseId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }
}
