package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.BorrowResource;
import com.xforceplus.elephantarchives.service.IBorrowResourceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-22
 */
@RestController
public class BorrowResourceController {

  @Autowired
  private IBorrowResourceService borrowResourceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param borrowResource ${table.comment}
   * @return
   */
  @GetMapping("/borrowresources" )
  public XfR getBorrowResources(XfPage page, BorrowResource borrowResource) {
    return XfR.ok(borrowResourceServiceImpl.page(page, Wrappers.query(borrowResource)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/borrowresources/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(borrowResourceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param borrowResource ${table.comment}
   * @return XfR
   */
  @PostMapping("/borrowresources")
  public XfR save(@RequestBody BorrowResource borrowResource) {
     return XfR.ok(borrowResourceServiceImpl.save(borrowResource));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param borrowResource ${table.comment}
   * @return XfR
   */
  @PutMapping("/borrowresources/{id}")
  public XfR putUpdate(@RequestBody BorrowResource borrowResource,@PathVariable Long id) {
      borrowResource.setId(id);
      return XfR.ok(borrowResourceServiceImpl.updateById(borrowResource));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param borrowResource ${table.comment}
   * @return XfR
   */
  @PatchMapping("/borrowresources/{id}")
  public XfR patchUpdate(@RequestBody BorrowResource borrowResource,@PathVariable Long id) {
      BorrowResource upborrowResource = borrowResourceServiceImpl.getById(id);
      if(upborrowResource != null){
        upborrowResource = ObjectCopyUtils.copyProperties(borrowResource,upborrowResource,true);
      }
      return XfR.ok(borrowResourceServiceImpl.updateById(upborrowResource));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/borrowresources/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(borrowResourceServiceImpl.removeById(id));
  }

  @PostMapping("/borrowresources/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "borrow_resource");
     params.put("request", condition);

     return XfR.ok(borrowResourceServiceImpl.querys(params));
  }

}
