package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.VolumeSubmitRecord;
import com.xforceplus.elephantarchives.service.IVolumeSubmitRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-22
 */
@RestController
public class VolumeSubmitRecordController {

  @Autowired
  private IVolumeSubmitRecordService volumeSubmitRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param volumeSubmitRecord ${table.comment}
   * @return
   */
  @GetMapping("/volumesubmitrecords" )
  public XfR getVolumeSubmitRecords(XfPage page, VolumeSubmitRecord volumeSubmitRecord) {
    return XfR.ok(volumeSubmitRecordServiceImpl.page(page, Wrappers.query(volumeSubmitRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/volumesubmitrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(volumeSubmitRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param volumeSubmitRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/volumesubmitrecords")
  public XfR save(@RequestBody VolumeSubmitRecord volumeSubmitRecord) {
     return XfR.ok(volumeSubmitRecordServiceImpl.save(volumeSubmitRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param volumeSubmitRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/volumesubmitrecords/{id}")
  public XfR putUpdate(@RequestBody VolumeSubmitRecord volumeSubmitRecord,@PathVariable Long id) {
      volumeSubmitRecord.setId(id);
      return XfR.ok(volumeSubmitRecordServiceImpl.updateById(volumeSubmitRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param volumeSubmitRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/volumesubmitrecords/{id}")
  public XfR patchUpdate(@RequestBody VolumeSubmitRecord volumeSubmitRecord,@PathVariable Long id) {
      VolumeSubmitRecord upvolumeSubmitRecord = volumeSubmitRecordServiceImpl.getById(id);
      if(upvolumeSubmitRecord != null){
        upvolumeSubmitRecord = ObjectCopyUtils.copyProperties(volumeSubmitRecord,upvolumeSubmitRecord,true);
      }
      return XfR.ok(volumeSubmitRecordServiceImpl.updateById(upvolumeSubmitRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/volumesubmitrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(volumeSubmitRecordServiceImpl.removeById(id));
  }

  @PostMapping("/volumesubmitrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "volume_submit_record");
     params.put("request", condition);

     return XfR.ok(volumeSubmitRecordServiceImpl.querys(params));
  }

}
