package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.TicketInvoice;
import com.xforceplus.elephantarchives.service.ITicketInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-26
 */
@RestController
public class TicketInvoiceController {

  @Autowired
  private ITicketInvoiceService ticketInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketInvoice ${table.comment}
   * @return
   */
  @GetMapping("/ticketinvoices" )
  public XfR getTicketInvoices(XfPage page, TicketInvoice ticketInvoice) {
    return XfR.ok(ticketInvoiceServiceImpl.page(page, Wrappers.query(ticketInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketinvoices")
  public XfR save(@RequestBody TicketInvoice ticketInvoice) {
     return XfR.ok(ticketInvoiceServiceImpl.save(ticketInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketinvoices/{id}")
  public XfR putUpdate(@RequestBody TicketInvoice ticketInvoice,@PathVariable Long id) {
      ticketInvoice.setId(id);
      return XfR.ok(ticketInvoiceServiceImpl.updateById(ticketInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketinvoices/{id}")
  public XfR patchUpdate(@RequestBody TicketInvoice ticketInvoice,@PathVariable Long id) {
      TicketInvoice upticketInvoice = ticketInvoiceServiceImpl.getById(id);
      if(upticketInvoice != null){
        upticketInvoice = ObjectCopyUtils.copyProperties(ticketInvoice,upticketInvoice,true);
      }
      return XfR.ok(ticketInvoiceServiceImpl.updateById(upticketInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/ticketinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_invoice");
     params.put("request", condition);

     return XfR.ok(ticketInvoiceServiceImpl.querys(params));
  }

}
