package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.TikcetPlane;
import com.xforceplus.elephantarchives.service.ITikcetPlaneService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-26
 */
@RestController
public class TikcetPlaneController {

  @Autowired
  private ITikcetPlaneService tikcetPlaneServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tikcetPlane ${table.comment}
   * @return
   */
  @GetMapping("/tikcetplanes" )
  public XfR getTikcetPlanes(XfPage page, TikcetPlane tikcetPlane) {
    return XfR.ok(tikcetPlaneServiceImpl.page(page, Wrappers.query(tikcetPlane)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tikcetplanes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tikcetPlaneServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tikcetPlane ${table.comment}
   * @return XfR
   */
  @PostMapping("/tikcetplanes")
  public XfR save(@RequestBody TikcetPlane tikcetPlane) {
     return XfR.ok(tikcetPlaneServiceImpl.save(tikcetPlane));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tikcetPlane ${table.comment}
   * @return XfR
   */
  @PutMapping("/tikcetplanes/{id}")
  public XfR putUpdate(@RequestBody TikcetPlane tikcetPlane,@PathVariable Long id) {
      tikcetPlane.setId(id);
      return XfR.ok(tikcetPlaneServiceImpl.updateById(tikcetPlane));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tikcetPlane ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tikcetplanes/{id}")
  public XfR patchUpdate(@RequestBody TikcetPlane tikcetPlane,@PathVariable Long id) {
      TikcetPlane uptikcetPlane = tikcetPlaneServiceImpl.getById(id);
      if(uptikcetPlane != null){
        uptikcetPlane = ObjectCopyUtils.copyProperties(tikcetPlane,uptikcetPlane,true);
      }
      return XfR.ok(tikcetPlaneServiceImpl.updateById(uptikcetPlane));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tikcetplanes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tikcetPlaneServiceImpl.removeById(id));
  }

  @PostMapping("/tikcetplanes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tikcet_plane");
     params.put("request", condition);

     return XfR.ok(tikcetPlaneServiceImpl.querys(params));
  }

}
