/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephantarchives.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.elephantarchives.entity.Warehouse;
import com.xforceplus.elephantarchives.service.IWarehouseService;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WarehouseController {
    @Autowired
    private IWarehouseService warehouseServiceImpl;

    @GetMapping(value={"/warehouses"})
    public XfR getWarehouses(XfPage page, Warehouse warehouse) {
        return XfR.ok((Object)this.warehouseServiceImpl.page((IPage)page, (Wrapper)Wrappers.query((Object)warehouse)));
    }

    @GetMapping(value={"/warehouses/{id}"})
    public XfR getById(@PathVariable Long id) {
        return XfR.ok((Object)this.warehouseServiceImpl.getById(id));
    }

    @PostMapping(value={"/warehouses"})
    public XfR save(@RequestBody Warehouse warehouse) {
        return XfR.ok((Object)this.warehouseServiceImpl.save(warehouse));
    }

    @PutMapping(value={"/warehouses/{id}"})
    public XfR putUpdate(@RequestBody Warehouse warehouse, @PathVariable Long id) {
        warehouse.setId(id);
        return XfR.ok((Object)this.warehouseServiceImpl.updateById(warehouse));
    }

    @PatchMapping(value={"/warehouses/{id}"})
    public XfR patchUpdate(@RequestBody Warehouse warehouse, @PathVariable Long id) {
        Warehouse upwarehouse = (Warehouse)this.warehouseServiceImpl.getById(id);
        if (upwarehouse != null) {
            upwarehouse = (Warehouse)ObjectCopyUtils.copyProperties((Object)warehouse, (Object)upwarehouse, (boolean)true);
        }
        return XfR.ok((Object)this.warehouseServiceImpl.updateById(upwarehouse));
    }

    @DeleteMapping(value={"/warehouses/{id}"})
    public XfR removeById(@PathVariable Long id) {
        return XfR.ok((Object)this.warehouseServiceImpl.removeById(id));
    }

    @PostMapping(value={"/warehouses/query"})
    public XfR querys(@RequestBody ConditionQueryRequest condition) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", "warehouse");
        params.put("request", condition);
        return XfR.ok(this.warehouseServiceImpl.querys(params));
    }
}

