package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.Style;
import com.xforceplus.elephantarchives.service.IStyleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-26
 */
@RestController
public class StyleController {

  @Autowired
  private IStyleService styleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param style ${table.comment}
   * @return
   */
  @GetMapping("/styles" )
  public XfR getStyles(XfPage page, Style style) {
    return XfR.ok(styleServiceImpl.page(page, Wrappers.query(style)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/styles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(styleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param style ${table.comment}
   * @return XfR
   */
  @PostMapping("/styles")
  public XfR save(@RequestBody Style style) {
     return XfR.ok(styleServiceImpl.save(style));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param style ${table.comment}
   * @return XfR
   */
  @PutMapping("/styles/{id}")
  public XfR putUpdate(@RequestBody Style style,@PathVariable Long id) {
      style.setId(id);
      return XfR.ok(styleServiceImpl.updateById(style));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param style ${table.comment}
   * @return XfR
   */
  @PatchMapping("/styles/{id}")
  public XfR patchUpdate(@RequestBody Style style,@PathVariable Long id) {
      Style upstyle = styleServiceImpl.getById(id);
      if(upstyle != null){
        upstyle = ObjectCopyUtils.copyProperties(style,upstyle,true);
      }
      return XfR.ok(styleServiceImpl.updateById(upstyle));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/styles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(styleServiceImpl.removeById(id));
  }

  @PostMapping("/styles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "style");
     params.put("request", condition);

     return XfR.ok(styleServiceImpl.querys(params));
  }

}
