package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.LocationOrg;
import com.xforceplus.elephantarchives.service.ILocationOrgService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-02-05
 */
@RestController
public class LocationOrgController {

  @Autowired
  private ILocationOrgService locationOrgServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param locationOrg ${table.comment}
   * @return
   */
  @GetMapping("/locationorgs" )
  public XfR getLocationOrgs(XfPage page, LocationOrg locationOrg) {
    return XfR.ok(locationOrgServiceImpl.page(page, Wrappers.query(locationOrg)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/locationorgs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(locationOrgServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param locationOrg ${table.comment}
   * @return XfR
   */
  @PostMapping("/locationorgs")
  public XfR save(@RequestBody LocationOrg locationOrg) {
     return XfR.ok(locationOrgServiceImpl.save(locationOrg));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param locationOrg ${table.comment}
   * @return XfR
   */
  @PutMapping("/locationorgs/{id}")
  public XfR putUpdate(@RequestBody LocationOrg locationOrg,@PathVariable Long id) {
      locationOrg.setId(id);
      return XfR.ok(locationOrgServiceImpl.updateById(locationOrg));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param locationOrg ${table.comment}
   * @return XfR
   */
  @PatchMapping("/locationorgs/{id}")
  public XfR patchUpdate(@RequestBody LocationOrg locationOrg,@PathVariable Long id) {
      LocationOrg uplocationOrg = locationOrgServiceImpl.getById(id);
      if(uplocationOrg != null){
        uplocationOrg = ObjectCopyUtils.copyProperties(locationOrg,uplocationOrg,true);
      }
      return XfR.ok(locationOrgServiceImpl.updateById(uplocationOrg));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/locationorgs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(locationOrgServiceImpl.removeById(id));
  }

  @PostMapping("/locationorgs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "location_org");
     params.put("request", condition);

     return XfR.ok(locationOrgServiceImpl.querys(params));
  }

}
