package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.Attachment1;
import com.xforceplus.elephantarchives.service.IAttachment1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-08
 */
@RestController
public class Attachment1Controller {

  @Autowired
  private IAttachment1Service attachment1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param attachment1 ${table.comment}
   * @return
   */
  @GetMapping("/attachment1s" )
  public XfR getAttachment1s(XfPage page, Attachment1 attachment1) {
    return XfR.ok(attachment1ServiceImpl.page(page, Wrappers.query(attachment1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/attachment1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(attachment1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param attachment1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/attachment1s")
  public XfR save(@RequestBody Attachment1 attachment1) {
     return XfR.ok(attachment1ServiceImpl.save(attachment1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param attachment1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/attachment1s/{id}")
  public XfR putUpdate(@RequestBody Attachment1 attachment1,@PathVariable Long id) {
      attachment1.setId(id);
      return XfR.ok(attachment1ServiceImpl.updateById(attachment1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param attachment1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/attachment1s/{id}")
  public XfR patchUpdate(@RequestBody Attachment1 attachment1,@PathVariable Long id) {
      Attachment1 upattachment1 = attachment1ServiceImpl.getById(id);
      if(upattachment1 != null){
        upattachment1 = ObjectCopyUtils.copyProperties(attachment1,upattachment1,true);
      }
      return XfR.ok(attachment1ServiceImpl.updateById(upattachment1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/attachment1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(attachment1ServiceImpl.removeById(id));
  }

  @PostMapping("/attachment1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "attachment1");
     params.put("request", condition);

     return XfR.ok(attachment1ServiceImpl.querys(params));
  }

}
