package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.Location;
import com.xforceplus.elephantarchives.service.ILocationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-26
 */
@RestController
public class LocationController {

  @Autowired
  private ILocationService locationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param location ${table.comment}
   * @return
   */
  @GetMapping("/locations" )
  public XfR getLocations(XfPage page, Location location) {
    return XfR.ok(locationServiceImpl.page(page, Wrappers.query(location)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/locations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(locationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param location ${table.comment}
   * @return XfR
   */
  @PostMapping("/locations")
  public XfR save(@RequestBody Location location) {
     return XfR.ok(locationServiceImpl.save(location));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param location ${table.comment}
   * @return XfR
   */
  @PutMapping("/locations/{id}")
  public XfR putUpdate(@RequestBody Location location,@PathVariable Long id) {
      location.setId(id);
      return XfR.ok(locationServiceImpl.updateById(location));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param location ${table.comment}
   * @return XfR
   */
  @PatchMapping("/locations/{id}")
  public XfR patchUpdate(@RequestBody Location location,@PathVariable Long id) {
      Location uplocation = locationServiceImpl.getById(id);
      if(uplocation != null){
        uplocation = ObjectCopyUtils.copyProperties(location,uplocation,true);
      }
      return XfR.ok(locationServiceImpl.updateById(uplocation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/locations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(locationServiceImpl.removeById(id));
  }

  @PostMapping("/locations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "location");
     params.put("request", condition);

     return XfR.ok(locationServiceImpl.querys(params));
  }

}
