package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.OtherVoucher;
import com.xforceplus.elephantarchives.service.IOtherVoucherService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-26
 */
@RestController
public class OtherVoucherController {

  @Autowired
  private IOtherVoucherService otherVoucherServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param otherVoucher ${table.comment}
   * @return
   */
  @GetMapping("/othervouchers" )
  public XfR getOtherVouchers(XfPage page, OtherVoucher otherVoucher) {
    return XfR.ok(otherVoucherServiceImpl.page(page, Wrappers.query(otherVoucher)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/othervouchers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(otherVoucherServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param otherVoucher ${table.comment}
   * @return XfR
   */
  @PostMapping("/othervouchers")
  public XfR save(@RequestBody OtherVoucher otherVoucher) {
     return XfR.ok(otherVoucherServiceImpl.save(otherVoucher));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param otherVoucher ${table.comment}
   * @return XfR
   */
  @PutMapping("/othervouchers/{id}")
  public XfR putUpdate(@RequestBody OtherVoucher otherVoucher,@PathVariable Long id) {
      otherVoucher.setId(id);
      return XfR.ok(otherVoucherServiceImpl.updateById(otherVoucher));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param otherVoucher ${table.comment}
   * @return XfR
   */
  @PatchMapping("/othervouchers/{id}")
  public XfR patchUpdate(@RequestBody OtherVoucher otherVoucher,@PathVariable Long id) {
      OtherVoucher upotherVoucher = otherVoucherServiceImpl.getById(id);
      if(upotherVoucher != null){
        upotherVoucher = ObjectCopyUtils.copyProperties(otherVoucher,upotherVoucher,true);
      }
      return XfR.ok(otherVoucherServiceImpl.updateById(upotherVoucher));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/othervouchers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(otherVoucherServiceImpl.removeById(id));
  }

  @PostMapping("/othervouchers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "other_voucher");
     params.put("request", condition);

     return XfR.ok(otherVoucherServiceImpl.querys(params));
  }

}
